<?php
/**
 * The template for displaying the header
 *
 * Displays all of the head element and everything up until the "site-content" div.
 *
 * @package WordPress
 * @subpackage Superio
 * @since Superio 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
	<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Corporation",
  "name": "VieclamSale247.Com Cung Cấp Việc Làm, Tuyển Dụng Sale Trên Thị Trường",
  "alternateName": "VieclamSale247",
  "url": "http://vieclamsale247.com/",
  "logo": "https://vieclamsale247.com/wp-content/uploads/elementor/thumbs/marketing-sale247-qkjtgv0kdagzc72q5ycbw1sfp1ke6jgdaf14ijj19k.png",
  "contactPoint": {
    "@type": "ContactPoint",
    "telephone": "0829 722 235",
    "contactType": "technical support",
    "contactOption": "TollFree",
    "areaServed": "VN",
    "availableLanguage": "Vietnamese"
  },
  "sameAs": [
    "https://sites.google.com/view/vieclamsale247/",
    "https://www.youtube.com/channel/UCXeDKts2Ui_zTtxMT51xAHQ/about",
    "https://twitter.com/vieclamsale247",
    "https://www.reddit.com/user/vieclamsale247/",
    "https://vieclamsale247.blogspot.com/",
    "https://www.pinterest.com/vieclamsale247/",
    "https://vieclamsale247.tumblr.com/",
    "https://www.blogger.com/profile/16722491628206766960"
  ]
}
</script>
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "ProfessionalService",
  "name": "VieclamSale247.Com Cung Cấp Việc Làm, Tuyển Dụng Sale Trên Thị Trường",
  "image": "https://vieclamsale247.com/wp-content/uploads/elementor/thumbs/marketing-sale247-qkjtgv0kdagzc72q5ycbw1sfp1ke6jgdaf14ijj19k.png",
  "@id": "http://vieclamsale247.com/",
  "url": "http://vieclamsale247.com/",
  "telephone": "0829 722 235",
  "address": {
    "@type": "PostalAddress",
    "streetAddress": "31 Lâm Hoành, An Lạc, Bình Tân, Thành phố Hồ Chí Minh, Việt Nam",
    "addressLocality": "Thành phố Hồ Chí Minh",
    "postalCode": "70000",
    "addressCountry": "VN"
  },
  "geo": {
    "@type": "GeoCoordinates",
    "latitude": 10.7364861,
    "longitude": 106.6157337
  },
  "openingHoursSpecification": {
    "@type": "OpeningHoursSpecification",
    "dayOfWeek": [
      "Monday",
      "Tuesday",
      "Wednesday",
      "Thursday",
      "Friday",
      "Saturday",
      "Sunday"
    ],
    "opens": "00:00",
    "closes": "23:59"
  },
  "sameAs": [
    "https://sites.google.com/view/vieclamsale247/",
    "https://www.youtube.com/channel/UCXeDKts2Ui_zTtxMT51xAHQ/about",
    "https://twitter.com/vieclamsale247",
    "https://vieclamsale247.blogspot.com/",
    "https://www.reddit.com/user/vieclamsale247/",
    "https://www.pinterest.com/vieclamsale247/",
    "https://vieclamsale247.tumblr.com/",
    "https://www.blogger.com/profile/16722491628206766960"
  ] 
}
</script>
	<script type="application/ld+json">
{
  "@context": "https://schema.org/",
  "@type": "Person",
  "name": "Phan Đức Minh",
  "url": "https://vieclamsale247.com/author/admin/",
  "image": "https://atpholdings.vn/wp-content/uploads/2020/11/cac-doanh-nhan-tre-thanh-dat-cua-viet-nam.jpg",
  "sameAs": [
    "https://sites.google.com/view/phan-duc-minh/",
    "https://www.youtube.com/channel/UCR0MbWfcnBc0pCgGbGYOpPw/about",
    "https://www.reddit.com/user/phan-duc-minh/",
    "https://twitter.com/phan_duc_minh",
    "https://phan-duc-minh.blogspot.com/",
    "https://www.pinterest.com/phan_duc_minh/",
    "https://phan-duc-minh.tumblr.com/",
    "https://www.blogger.com/profile/09498024395734656743"
  ],
  "jobTitle": "CEO",
  "worksFor": {
    "@type": "Organization",
    "name": "vieclamsale247.com"
  }  
}
</script>
	
	<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-ENDGDM1VHG"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-ENDGDM1VHG');
</script>
	<meta name='dmca-site-verification' content='UmEvb1duMk9pb1p2M2lZcDlUa3VpNG5GK21rS2JNVjEvOWVNcnFtRHhhbz01' />
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width">
	<link rel="profile" href="//gmpg.org/xfn/11">
	
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php if ( superio_get_config('preload', true) ) {
	$preload_icon = superio_get_config('media-preload-icon');
	$styles = array();
	if ( !empty($preload_icon['id']) ) {
		$img = wp_get_attachment_image_src($preload_icon['id'], 'full');
		if ( !empty($img[0]) ) {
			$styles[] = 'background-image: url(\''.$img[0].'\');';
		}
		if ( !empty($img[1]) ) {
			$styles[] = 'width: '.$img[1].'px;';
		}
		if ( !empty($img[1]) ) {
			$styles[] = 'height: '.$img[2].'px;';
		}
    }
    $style_attr = '';
    if ( !empty($styles) ) {
    	$style_attr = 'style="'.implode(' ', $styles).'"';
    }
?>
	<div class="apus-page-loading">
        <div class="apus-loader-inner" <?php echo trim($style_attr); ?>></div>
    </div>
<?php } ?>
<div id="wrapper-container" class="wrapper-container">
	<?php
    if ( function_exists( 'wp_body_open' ) ) {
        wp_body_open();
    }
    if ( superio_get_config('separate_header_mobile', true) ) {
	    get_template_part( 'headers/mobile/offcanvas-menu' );
		get_template_part( 'headers/mobile/header-mobile' );
	}
	?>

	<?php
		$header = apply_filters( 'superio_get_header_layout', superio_get_config('header_type') );
		if ( !empty($header) ) {
			superio_display_header_builder($header);
		} else {
			get_template_part( 'headers/default' );
		}
	?>
	<div id="apus-main-content">